<?php

   /*
    *
    * copyright (c) 2013-2023 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    *
    */

    include "../include/costanti.php";
    include "../include/util.php";
    include "../gUtil/DbManager.php";
    include "../gUtil/GestoreUpload.php";
    include "../gUtil/ElaboratoreImmagini.php";
    include "../classi/GeneratoreUrl.php";
    include "../classi/FileScaricabile.php";
    
    //i dati del database sono definiti nel file costanti.php
    $geecomDb      = new DbManager($costantiDatabase);
    $impostazioni = recuperaImpostazioni($geecomDb);
    
    session_start();
    controlloAccessoAdmin();
    
    if(isset($_GET["operazione"])) {
        $operazione = filter_input(INPUT_GET,"operazione",FILTER_SANITIZE_STRING);
        $idRisorsa   = isset($_GET["id"]) ? filter_input(INPUT_GET,"id",FILTER_SANITIZE_NUMBER_INT) : 0;
    }
    else {
        $operazione = filter_input(INPUT_POST,"operazione",FILTER_SANITIZE_STRING);
        $idRisorsa   = isset($_POST["id"]) ? filter_input(INPUT_POST,"id",FILTER_SANITIZE_NUMBER_INT) : 0;
    }
    
    $fileScaricabile = new FileScaricabile($geecomDb, $idRisorsa);
    
    // dato che serve in molti switch per capire la pagina a cui l'utente deve essere rediretto
    $datiProdottoGeecom = $geecomDb->leggiSingolaRiga("geec_prodotti", 1) ;
    $percorsoGeecomCMS  = GeneratoreUrl::creaUrlAreaAmministrativa($impostazioni,$datiProdottoGeecom);
        
    switch ($operazione) {
        case 'creaFileScaricabile':
            $fileScaricabile->setNome("");
            $idRisorsa = $fileScaricabile->crea();
            header("Location: $percorsoGeecomCMS/creaFileScaricabile.php?id=$idRisorsa&status=200");
            break;
        case 'modificaFileScaricabile':
            $fileScaricabile->caricaDatiDalDatabase();
            $fileScaricabile->setNome(filter_input(INPUT_POST,"nome",FILTER_SANITIZE_ADD_SLASHES));
            $fileScaricabile->setDescrizione(filter_input(INPUT_POST,"descrizione",FILTER_SANITIZE_STRING));
            $fileScaricabile->setCategoria(filter_input(INPUT_POST,"categoria",FILTER_SANITIZE_NUMBER_INT));
            $fileScaricabile->setAccessibilita(filter_input(INPUT_POST,"accessibilita",FILTER_SANITIZE_STRING));
            $fileScaricabile->setPassword("");
            $fileScaricabile->modifica();
            echo "ok";
            break;
        case 'duplicaRisorsa':
            $fileScaricabile->caricaDatiDalDatabase();
            $idRisorsa = $fileScaricabile->duplica();
            header("Location: $percorsoGeecomCMS/creaFileScaricabile.php?id=$idRisorsa&status=230");
            break;
        case 'aggiungiRisorsaAGruppo':
            $idGruppo = filter_input(INPUT_POST,"idGruppo",FILTER_SANITIZE_NUMBER_INT);
            $fileScaricabile->aggiungiAGruppo($idGruppo);
            echo"ok";
            break;
        case 'eliminaGruppoRisorsa':
            $idGruppo = filter_input(INPUT_POST,"idGruppo",FILTER_SANITIZE_NUMBER_INT);
            $query = "DELETE FROM geecB_gruppiDestinatari WHERE idRisorsa = {$fileScaricabile->getId()} AND idGruppoDestinatario=$idGruppo";
            $geecomDb->eseguiQueryLettura($query);
            echo"ok";
            break;
        case 'modificaFile':
            if($_FILES['file']['name']!="") {  // il codice viene eseguito solo se c'è un file
                $tipiFileAmmessi = array("image/png","image/jpeg","image/webp","image/gif","application/pdf",'application/msword',"application/vnd.ms-excel","application/vnd.ms-powerpoint","application/vnd.oasis.opendocument.text","application/vnd.oasis.opendocument.spreadsheet","application/zip","application/x-rar-compressed");
                $gestoreUpload = new GestoreUpload("file", $tipiFileAmmessi, 8, "../file/risorse", 0, "");
                $esitoUpload  = $gestoreUpload->salvaFile();
                if($esitoUpload["percorso"]=="") {
                    echo "Errore: file non ammesso";
                    exit();
                }
                else {
                    $percorsoFile = str_replace("../","",$esitoUpload["percorso"]);
                }
                $fileScaricabile->aggiornaPercorsoFile($percorsoFile);
                echo " <b>".str_replace("file/risorse/","",$percorsoFile)."</b>";
            }
            break;
        case 'modificaImmagine':
            if($_FILES['file']['name']=="") { //se non c'è l'immagine percorsoFoto = vuoto
                $percorsoFoto ="";
                $percorsoThumbnail = "";
            }
            else { //se c'è l'immagine viene salvata e inserita nel percorso foto
                $tipiFileAmmessi = array("image/png","image/jpeg","image/webp","image/gif");
                $gestoreUpload = new GestoreUpload("file", $tipiFileAmmessi, 8, "../immagini/risorse", 0, "");
                $esitoUpload  = $gestoreUpload->salvaFile();
                if($esitoUpload["percorso"]=="") {
                    echo "Errore: formato immagine non ammesso";
                    exit();
                }
                else {
                    $percorsoFoto = str_replace("../","",$esitoUpload["percorso"]);
                }

                // se nelle impostazioni è spuintata la voce  "ottimizza immagini caricate" viene modificata
                if($impostazioni["ottimizzaImmaginiCaricate"]=="si") {
                    $elaboratoreImmagini = new ElaboratoreImmagini($esitoUpload["percorso"]);
                    if($elaboratoreImmagini->getAltezza()>$impostazioni["altezzaImmagine"]) {
                        $elaboratoreImmagini->modificaInScala("altezza", $impostazioni["altezzaImmagine"], $esitoUpload["percorso"]);
                    }
                }

                if($impostazioni["generaThumbnail"]=="si") {
                    $percorsoFileThumbnail = str_replace("immagini/","immagini/thumbnail/",$esitoUpload["percorso"]);
                    $percorsoThumbnail = str_replace("../","",$percorsoFileThumbnail);
                    $elaboratoreImmagini->modificaInScala("altezza", $impostazioni["altezzaThumbnail"], $percorsoFileThumbnail);
                }
            }
    

            $fileScaricabile->modificaImmagine($percorsoFoto);
            echo "../$percorsoFoto";
            break;
        case 'eliminaImmagineInEvidenza':
             $fileScaricabile->modificaImmagine("");
            echo "ok";
            break;
        case 'stampaGruppiAssociatiRisorsa':
            $query = "SELECT * FROM geecB_gruppiDestinatari WHERE idRisorsa = {$fileScaricabile->getId()}";
            $risGruppiUtente = $geecomDb->eseguiQueryLettura($query);
            if($risGruppiUtente->num_rows==0) {
                echo"<h4 id=\"stringaNessunGruppo\">Questo file non è associato a gruppi </h4>";
            }
            else {
                while($gruppo = $risGruppiUtente->fetch_assoc()) {    
                    $datiGruppo = $geecomDb->leggiSIngolaRiga("geec_gruppi",$gruppo["idGruppoDestinatario"]);
                    echo"<div id=\"divGruppo{$datiGruppo["id"]}\" class=\"d-inline-block mr-2 mb-2\">
                            <button type=\"button\" class=\"btn btn-primary round\" onclick=\"eliminaGruppoRisorsa({$datiGruppo["id"]})\">{$datiGruppo["nome"]}<i class=\"fas fa-times ml-2\"></i></button>
                        </div>";
                }
            }
            break;
        case 'eliminaFileScaricabile':
            $fileScaricabile->elimina();
            echo"ok";
            break;
        case 'stampaElencoCategorie':
            $query = "SELECT * FROM `geec_categorie` WHERE tipo LIKE 'risorsa'";
            $risCategorie = $geecomDb->eseguiQueryLettura($query);
            
            while($categoria = $risCategorie->fetch_assoc()) {
                echo"<div id=\"categoria{$categoria["id"]}\" class=\"col-sm-6 col-lg-4\">
                        <div class=\"card-body mb-3 py-1 px-2 bg-light border rounded d-sm-flex justify-content-between align-items-center text-center\">
                            <div class=\"mb-1 mb-sm-0 text-muted w-50 text-left\">
                                <p class=\"mb-0\"><em><strong>{$categoria["nome"]}</strong></em>  </p>
                                <small><em>0 file</em></small>
                            </div>
                            <div class=\"azioni d-flex align-items-center justify-content-end\">
                                <div class=\"btn-group\" role=\"group\" aria-label=\"Basic example\">
                                    <button type=\"button\" class=\"btn btn-light modifica\" data-toggle=\"tooltip\" data-placement=\"bottom\" title=\"Modifica\" onclick=\"modificaCategoria({$categoria["id"]},'{$categoria["nome"]}')\"><i class=\"far fa-edit\"></i></button>
                                    <button type=\"button\" class=\"btn btn-light elimina\" data-toggle=\"tooltip\" data-placement=\"bottom\" title=\"Elimina\" onclick=\"eliminaCategoria({$categoria["id"]},'{$categoria["nome"]}')\" ><i class=\"far fa-trash-alt\"></i></button>
                                </div>
                           </div>
                        </div>
                    </div>";
            }
            break;
        case 'creaCategoriaRisorsa':
            $data  = date("Y-m-d");
            $nome  = filter_input(INPUT_POST,"nome",FILTER_SANITIZE_ADD_SLASHES);
            $alias = str_replace(" ", "-", $nome);
            $query = "INSERT INTO `geec_categorie` (`id`, `categoriaMadre`, `categoriaRiferimento`, `tipo`, `lingua`, `nome`, `alias`, `titoloPagina`, `metaDescrizione`, `cssGenerato`, `cssAggiuntivo`, `foto`, `punteggioSeo`, `tipoVisualizzazione`, `numeroArticoliPerPagina`, `posizione`, `ordinamento`, `dataCreazione`) VALUES (NULL, '0', '0', 'risorsa', 'italiano', '$nome', '$alias', '', '', '', '', '', '', '', NULL, NULL, NULL, '$data')";
            $idCategoria = $geecomDb->eseguiQueryCreazione($query);
            
            echo"<div id=\"categoria{$idCategoria}\" class=\"col-sm-6 col-lg-4\">
                    <div class=\"card-body mb-3 py-1 px-2 bg-light border rounded d-sm-flex justify-content-between align-items-center text-center\">
                        <div class=\"mb-1 mb-sm-0 text-muted w-50 text-left\">
                            <p class=\"mb-0\"><em><strong>{$_POST["nome"]}</strong></em>  </p>
                            <small><em>0 file</em></small>
                        </div>
                        <div class=\"azioni d-flex align-items-center justify-content-end\">
                            <div class=\"btn-group\" role=\"group\" aria-label=\"Basic example\">
                                <button type=\"button\" class=\"btn btn-light modifica\" data-toggle=\"tooltip\" data-placement=\"bottom\" title=\"Modifica\" onclick=\"modificaCategoria($idCategoria,'{$nome}')\"><i class=\"far fa-edit\"></i></button>
                                <button type=\"button\" class=\"btn btn-light elimina\" data-toggle=\"tooltip\" data-placement=\"bottom\" title=\"Elimina\" onclick=\"eliminaCategoria({$idCategoria},'{$nome}')\" ><i class=\"far fa-trash-alt\"></i></button>
                            </div>
                       </div>
                    </div>
                </div>";
            break;
        case 'modificaCategoriaRisorsa':
            $idCategoria = filter_input(INPUT_POST,"idCategoria",FILTER_SANITIZE_NUMBER_INT);
            $nome        = filter_input(INPUT_POST,"nome",FILTER_SANITIZE_ADD_SLASHES);
            $query       = "UPDATE `geec_categorie` SET nome='$nome' WHERE id=$idCategoria";
            $geecomDb->eseguiQueryScrittura($query);
            echo "ok";
            break;
        case 'eliminaCategoriaRisorsa': // questa azione viene usata quando si eliminano immagini dall'area risorse
            $idCategoria = filter_input(INPUT_POST,"id",FILTER_SANITIZE_NUMBER_INT);
            $geecomDb->eseguiQueryCancellazione("geec_categorie", $idCategoria);
            echo "ok";
            break;
        case 'eliminaFileRisorsa': // questa azione viene usata quando si eliminano immagini dall'area risorse
            $percorso = filter_input(INPUT_POST,"percorso",FILTER_SANITIZE_STRING);
            unlink($percorso);
            echo "ok";
            break;
        case 'stampaImmaginiCartellaArticoli':
            $immaginePartenza = filter_input(INPUT_POST,"immaginePartenza",FILTER_SANITIZE_NUMBER_INT);
            $numeroImmagini   = filter_input(INPUT_POST,"numeroImmagini",FILTER_SANITIZE_NUMBER_INT);
            $ultimaImmagine   = $immaginePartenza + $numeroImmagini+2; // il + 2 si riferisce a . e ..
            $gestoreUpload    = new GestoreUpload("",array(),100,"../immagini",100,"");
            $ImmaginiArticoli = $gestoreUpload->fileCartella("articoli");
            $percorsoBase     = "immagini/articoli";

            $immagineCorrente = 0;
            foreach($ImmaginiArticoli as $img) {
                if($immagineCorrente>$immaginePartenza && $immagineCorrente<$ultimaImmagine) {
                    $idDiv = "immagineArticolo$img";
                    if($img != ".." && $img !=".") {
                        ?>
                        <div class="col-6  col-xl-2 mb-3" id="<?php echo $idDiv ?>">
                            <div class="border p-2 h-100">
                                <div class="img-container">
                                    <a href="javascritpt:void" onclick="cambiaImmagineInEvidenzaDaPopup('<?php echo "$percorsoBase/$img" ?>')"><img class="img-fluid" src="<?php echo "../$percorsoBase/$img" ?>"></a>
                                </div>
                                <h6 class="mt-2 mb-0 text-truncate"><strong><?php echo $img ?></strong></h6>
                            </div>
                        </div>
                        <?php
                    }
                }
                $immagineCorrente++;
                if($immagineCorrente>$ultimaImmagine) {
                    break;
                }
            }
            break;
        case 'stampaImmaginiCartellaCategorie':
            $immaginePartenza = filter_input(INPUT_POST,"immaginePartenza",FILTER_SANITIZE_NUMBER_INT);
            $numeroImmagini   = filter_input(INPUT_POST,"numeroImmagini",FILTER_SANITIZE_NUMBER_INT);
            $ultimaImmagine   = $immaginePartenza + $numeroImmagini+2; // il + 2 si riferisce a . e ..
            $gestoreUpload    = new GestoreUpload("",array(),100,"../immagini",100,"");
            $ImmaginiSlider   = $gestoreUpload->fileCartella("categorie");
            $percorsoBase     = "immagini/categorie";

            $immagineCorrente = 0;
            foreach($ImmaginiSlider as $img) {
                if($immagineCorrente>$immaginePartenza && $immagineCorrente<$ultimaImmagine) {
                    $idDiv = "immagineCategoria$img";
                    if($img != ".." && $img !=".") {
                        ?>
                        <div class="col-6  col-xl-2 mb-3" id="<?php echo $idDiv ?>">
                            <div class="border p-2 h-100">
                                <div class="img-container">
                                    <a href="javascritpt:void" onclick="cambiaImmagineInEvidenzaDaPopup('<?php echo "$percorsoBase/$img" ?>')"><img class="img-fluid" src="<?php echo "../$percorsoBase/$img" ?>"></a>
                                </div>
                                <h6 class="mt-2 mb-0 text-truncate"><strong><?php echo $img ?></strong></h6>
                            </div>
                        </div>
                        <?php
                    }
                }
                $immagineCorrente++;
                if($immagineCorrente>$ultimaImmagine) {
                    break;
                }
            }
            break;
        case 'stampaImmaginiCartellaSlider':
            $immaginePartenza = filter_input(INPUT_POST,"immaginePartenza",FILTER_SANITIZE_NUMBER_INT);
            $numeroImmagini   = filter_input(INPUT_POST,"numeroImmagini",FILTER_SANITIZE_NUMBER_INT);
            $ultimaImmagine   = $immaginePartenza + $numeroImmagini+2; // il + 2 si riferisce a . e ..
            $gestoreUpload    = new GestoreUpload("",array(),100,"../immagini",100,"");
            $ImmaginiSlider   = $gestoreUpload->fileCartella("slider");
            $percorsoBase     = "immagini/slider";

            $immagineCorrente = 0;
            foreach($ImmaginiSlider as $img) {
                if($immagineCorrente>$immaginePartenza && $immagineCorrente<$ultimaImmagine) {
                    $idDiv = "immagineSlider$img";
                    if($img != ".." && $img !=".") {
                        ?>
                        <div class="col-6  col-xl-2 mb-3" id="<?php echo $idDiv ?>">
                            <div class="border p-2 h-100">
                                <div class="img-container">
                                    <a href="javascritpt:void" onclick="cambiaImmagineInEvidenzaDaPopup('<?php echo "$percorsoBase/$img" ?>')"><img class="img-fluid" src="<?php echo "../../../$percorsoBase/$img" ?>"></a>
                                </div>
                                <h6 class="mt-2 mb-0 text-truncate"><strong><?php echo $img ?></strong></h6>
                            </div>
                        </div>
                        <?php
                    }
                }
                $immagineCorrente++;
                if($immagineCorrente>$ultimaImmagine) {
                    break;
                }
            }
            break;
        case 'stampaImmaginiCartellaPopup':
            $immaginePartenza = filter_input(INPUT_POST,"immaginePartenza",FILTER_SANITIZE_NUMBER_INT);
            $numeroImmagini   = filter_input(INPUT_POST,"numeroImmagini",FILTER_SANITIZE_NUMBER_INT);
            $ultimaImmagine   = $immaginePartenza + $numeroImmagini+2; // il + 2 si riferisce a . e ..
            $gestoreUpload    = new GestoreUpload("",array(),100,"../immagini",100,"");
            $ImmaginiSlider   = $gestoreUpload->fileCartella("popup");
            $percorsoBase     = "immagini/popup";

            $immagineCorrente = 0;
            foreach($ImmaginiSlider as $img) {
                if($immagineCorrente>$immaginePartenza && $immagineCorrente<$ultimaImmagine) {
                    $idDiv = "immagineSlider$img";
                    if($img != ".." && $img !=".") {
                        ?>
                        <div class="col-6  col-xl-2 mb-3" id="<?php echo $idDiv ?>">
                            <div class="border p-2 h-100">
                                <div class="img-container">
                                    <a href="javascritpt:void" onclick="cambiaImmagineInEvidenzaDaPopup('<?php echo "$percorsoBase/$img" ?>')"><img class="img-fluid" src="<?php echo "../../../$percorsoBase/$img" ?>"></a>
                                </div>
                                <h6 class="mt-2 mb-0 text-truncate"><strong><?php echo $img ?></strong></h6>
                            </div>
                        </div>
                        <?php
                    }
                }
                $immagineCorrente++;
                if($immagineCorrente>$ultimaImmagine) {
                    break;
                }
            }
            break;
        case 'stampaImmaginiCartellaAltro':
            $immaginePartenza = filter_input(INPUT_POST,"immaginePartenza",FILTER_SANITIZE_NUMBER_INT);
            $numeroImmagini   = filter_input(INPUT_POST,"numeroImmagini",FILTER_SANITIZE_NUMBER_INT);
            $ultimaImmagine   = $immaginePartenza + $numeroImmagini+2; // il + 2 si riferisce a . e ..
            $gestoreUpload    = new GestoreUpload("",array(),100,"../immagini",100,"");
            $ImmaginiSlider   = $gestoreUpload->fileCartella("altro");
            $percorsoBase     = "immagini/altro";

            $immagineCorrente = 0;
            foreach($ImmaginiSlider as $img) {
                if($immagineCorrente>$immaginePartenza && $immagineCorrente<$ultimaImmagine) {
                    $idDiv = "immagineSlider$img";
                    if($img != ".." && $img !=".") {
                        ?>
                        <div class="col-6  col-xl-2 mb-3" id="<?php echo $idDiv ?>">
                            <div class="border p-2 h-100">
                                <div class="img-container">
                                    <a href="javascritpt:void" onclick="cambiaImmagineInEvidenzaDaPopup('<?php echo "$percorsoBase/$img" ?>')"><img class="img-fluid" src="<?php echo "../../../$percorsoBase/$img" ?>"></a>
                                </div>
                                <h6 class="mt-2 mb-0 text-truncate"><strong><?php echo $img ?></strong></h6>
                            </div>
                        </div>
                        <?php
                    }
                }
                $immagineCorrente++;
                if($immagineCorrente>$ultimaImmagine) {
                    break;
                }
            }
            break;
        case 'stampaImmaginiCartellaAltroBannerMobile':
            $immaginePartenza = filter_input(INPUT_POST,"immaginePartenza",FILTER_SANITIZE_NUMBER_INT);
            $numeroImmagini   = filter_input(INPUT_POST,"numeroImmagini",FILTER_SANITIZE_NUMBER_INT);
            $ultimaImmagine   = $immaginePartenza + $numeroImmagini+2; // il + 2 si riferisce a . e ..
            $gestoreUpload    = new GestoreUpload("",array(),100,"../immagini",100,"");
            $ImmaginiSlider   = $gestoreUpload->fileCartella("altro");
            $percorsoBase     = "immagini/altro";

            $immagineCorrente = 0;
            foreach($ImmaginiSlider as $img) {
                if($immagineCorrente>$immaginePartenza && $immagineCorrente<$ultimaImmagine) {
                    $idDiv = "immagineSlider$img";
                    if($img != ".." && $img !=".") {
                        ?>
                        <div class="col-6  col-xl-2 mb-3" id="<?php echo $idDiv ?>">
                            <div class="border p-2 h-100">
                                <div class="img-container">
                                    <a href="javascritpt:void" onclick="cambiaImmagineMobileDaPopup('<?php echo "$percorsoBase/$img" ?>')"><img class="img-fluid" src="<?php echo "../../../$percorsoBase/$img" ?>"></a>
                                </div>
                                <h6 class="mt-2 mb-0 text-truncate"><strong><?php echo $img ?></strong></h6>
                            </div>
                        </div>
                        <?php
                    }
                }
                $immagineCorrente++;
                if($immagineCorrente>$ultimaImmagine) {
                    break;
                }
            }
            break;
    }
